<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AddFieldActionTable extends Migration
{

    /**
     * Schema table name to migrate
     * @var string
     */
    public $set_schema_table = 'user_action';

    /**
     * Schema table name to migrate
     * @var string
     */
    public $after_field = 'prize_draw';

    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (!(Schema::hasTable($this->set_schema_table))) return;
        Schema::table($this->set_schema_table, function (Blueprint $table) {
            $table->string('green_pick_number', 255)->after($this->after_field);
            $table->string('green_prize_draw', 255)->after($this->after_field);
            $table->string('purple_pick_number', 255)->after($this->after_field);
            $table->string('purple_prize_draw', 255)->after($this->after_field);
            $table->boolean('fix')->default(false)->after($this->after_field);
            $table->boolean('win')->default(false)->after($this->after_field);
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        if(Schema::hasTable($this->set_schema_table)) {
            Schema::table($this->set_schema_table, function (Blueprint $table) {
                $table->dropColumn(['green_pick_number','green_prize_draw','purple_pick_number','purple_prize_draw', 'win', 'fix']);
            });
        }
    }
}
